/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.util.win32session;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.TextField;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.xvolks.jnative.JNative;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.MSG;
import org.xvolks.jnative.misc.basicStructures.HWND;
import org.xvolks.jnative.misc.basicStructures.LPARAM;
import org.xvolks.jnative.misc.basicStructures.LRESULT;
import org.xvolks.jnative.misc.basicStructures.UINT;
import org.xvolks.jnative.misc.basicStructures.WPARAM;
import org.xvolks.jnative.util.Callback;
import org.xvolks.jnative.util.Kernel32;
import org.xvolks.jnative.util.User32;
import org.xvolks.jnative.util.WindowProc;
import org.xvolks.jnative.util.constants.winuser.WM;

public class Win32SessionManager {
    private static final CallBackWindowProc console_proc = new CallBackWindowProc();
    private static List<EndSessionListener> listeners = new ArrayList<EndSessionListener>();
    private static HWND _hwnd = null;
    private static int oldWindowProc;
    private static PrintWriter log;
    private static FileOutputStream fLog;

    public static void addEndSessionListener(EndSessionListener listener) {
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    public static boolean removeEndSessionListener(EndSessionListener listener) {
        return listeners.remove(listener);
    }

    public static boolean fireQueryEndSessionOccured(EndSessionListener.Origin origin) {
        boolean ret = true;
        for (EndSessionListener l : listeners) {
            ret &= l.queryEndSessionOccured(origin);
        }
        return ret;
    }

    public static void fireEndSessionOccured(EndSessionListener.Origin origin) {
        for (EndSessionListener l : listeners) {
            l.endSessionOccured(origin);
        }
    }

    public static void fireShutdownOccured(EndSessionListener.Origin origin) {
        for (EndSessionListener l : listeners) {
            l.shutdownOccured(origin);
        }
    }

    public static boolean unregisterEndSessionHook() throws NativeException, IllegalAccessException {
        boolean ret = Kernel32.SetConsoleCtrlHandler(console_proc, false);
        if (JNative.isLogginEnabled()) {
            JNative.getLogger().log("RemoveConsoleHandler : " + ret);
        }
        if (ret) {
            console_proc.releaseCallbackAddress();
        }
        if (oldWindowProc != 0) {
            LRESULT result = User32.SendMessage(_hwnd, new UINT(WM.WM_CLOSE.getValue()), new WPARAM(0), new LPARAM(0));
            if (JNative.isLogginEnabled()) {
                JNative.getLogger().log("SendMessage WM_CLOSE returned " + result.getValue());
            }
            ret &= result.getValue() == 0;
        }
        return ret;
    }

    public static void registerEndSessionHook(final String windowName) throws NativeException, IllegalAccessException {
        if (JNative.isLogginEnabled()) {
            JNative.getLogger().log("SetConsoleHandler : " + Kernel32.SetConsoleCtrlHandler(console_proc, true));
        } else {
            Kernel32.SetConsoleCtrlHandler(console_proc, true);
        }
        new Thread(){
            {
                this.setDaemon(true);
                this.setName("EndSessionListener");
            }

            public void run() {
                WindowProc proc = new WindowProc(){

                    public int windowProc(int hwnd, int uMsg, int wParam, int lParam) {
                        Win32SessionManager.writeLog("log " + uMsg);
                        if (_hwnd != null || hwnd == (Integer)_hwnd.getValue()) {
                            if (uMsg == WM.WM_QUERYENDSESSION.getValue()) {
                                return Win32SessionManager.fireQueryEndSessionOccured(EndSessionListener.Origin.WINDOW) ? -1 : 0;
                            }
                            if (uMsg == WM.WM_ENDSESSION.getValue()) {
                                Win32SessionManager.fireEndSessionOccured(EndSessionListener.Origin.WINDOW);
                                return -1;
                            }
                            try {
                                int ret = User32.DefWindowProc(new HWND(hwnd), new UINT(uMsg), new WPARAM(wParam), new LPARAM(lParam)).getValue();
                                return ret;
                            }
                            catch (Exception ex) {
                                return 0;
                            }
                        }
                        JNative.getLogger().log("Je ne gere pas \u00e7a !");
                        return -1;
                    }
                };
                try {
                    _hwnd = new HWND(User32.CreateWindowEx(0, "Message", windowName == null ? "" : windowName, 0, 0, 0, 100, 100, 0, 0, JNative.getCurrentModule(), 0));
                    if (0 == (Integer)_hwnd.getValue()) {
                        JNative.getLogger().log("Failed to create the message listener window");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JNative.getLogger().log("Can't create the message listener window.");
                }
                try {
                    oldWindowProc = JNative.registerWindowProc(_hwnd, proc);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                try {
                    User32.ShowWindow(_hwnd, 0);
                    User32.UpdateWindow(_hwnd);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                MSG msg = null;
                try {
                    msg = new MSG();
                }
                catch (NativeException e) {
                    e.printStackTrace();
                }
                boolean lQuit = false;
                try {
                    while (!lQuit) {
                        switch (User32.GetMessage(msg, new HWND(0), 0, 0)) {
                            case -1: {
                                int error = Kernel32.GetLastError();
                                JNative.getLogger().log("Error occured: " + error);
                                lQuit = true;
                                break;
                            }
                            case 0: {
                                JNative.getLogger().log("WM_QUIT received");
                                lQuit = true;
                            }
                        }
                        User32.TranslateMessage(msg);
                        User32.DispatchMessage(msg);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }.start();
    }

    public static void writeLog(String message) {
        if (fLog == null) {
            try {
                fLog = new FileOutputStream("./Win32SessionManager.log");
                log = new PrintWriter(fLog);
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        Win32SessionManager.writeLog("Closing log");
                        log.close();
                    }
                });
            }
            catch (Exception e) {
                return;
            }
        }
        log.println("[" + new Date() + "] " + message);
        log.flush();
        try {
            fLog.getChannel().force(false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws NativeException, IllegalAccessException {
        Win32SessionManager.writeLog("Running");
        Win32SessionManager.addEndSessionListener(new EndSessionListener(){

            public void endSessionOccured(EndSessionListener.Origin org) {
                Win32SessionManager.writeLog("Fin de session par " + (Object)((Object)org));
            }

            public boolean queryEndSessionOccured(EndSessionListener.Origin org) {
                Win32SessionManager.writeLog("Demande de fin de session par " + (Object)((Object)org));
                return true;
            }

            public void shutdownOccured(EndSessionListener.Origin org) {
                Win32SessionManager.writeLog("Shutdown captured from " + (Object)((Object)org));
            }
        });
        Win32SessionManager.writeLog("Registring hook");
        Win32SessionManager.registerEndSessionHook("Noone");
        final Dialog d = new Dialog(new Frame());
        d.setModal(true);
        d.add(new TextField("Testing, please close session"));
        d.pack();
        d.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                d.dispose();
            }
        });
        d.setVisible(true);
        Win32SessionManager.writeLog("Exiting");
        System.exit(0);
    }

    static {
        log = null;
        fLog = null;
    }

    static class CallBackWindowProc
    implements Callback {
        private int instance = 0;

        CallBackWindowProc() {
        }

        public int HandlerRoutine(int msg) {
            switch (msg) {
                case 5: {
                    return Win32SessionManager.fireQueryEndSessionOccured(EndSessionListener.Origin.CONSOLE) ? 0 : 1;
                }
                case 6: {
                    Win32SessionManager.fireShutdownOccured(EndSessionListener.Origin.CONSOLE);
                    break;
                }
            }
            return 1;
        }

        public int callback(long[] values) {
            return this.HandlerRoutine((int)values[0]);
        }

        public int getCallbackAddress() throws NativeException {
            if (this.instance == 0) {
                this.instance = JNative.createCallback(1, this);
            }
            return this.instance;
        }

        public boolean releaseCallbackAddress() throws NativeException {
            if (this.instance != 0 && JNative.releaseCallback(this)) {
                this.instance = 0;
                return true;
            }
            return false;
        }
    }

    public static interface EndSessionListener {
        public boolean queryEndSessionOccured(Origin var1);

        public void endSessionOccured(Origin var1);

        public void shutdownOccured(Origin var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Origin {
            CONSOLE,
            WINDOW;

        }
    }
}

