/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.misc;

import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.basicStructures.AbstractBasicData;
import org.xvolks.jnative.misc.basicStructures.DC;
import org.xvolks.jnative.misc.basicStructures.LRECT;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PAINTSTRUCT
extends AbstractBasicData<PAINTSTRUCT> {
    public DC hdc;
    public boolean fErase;
    public LRECT rcPaint;
    public boolean fRestore;
    public boolean fIncUpdate;
    public byte[] rgbReserved = new byte[32];

    public PAINTSTRUCT() {
        super(null);
        try {
            this.createPointer();
        }
        catch (NativeException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public PAINTSTRUCT getValueFromPointer() throws NativeException {
        this.offset = 0;
        this.hdc = new DC(this.getNextInt());
        this.fErase = this.getNextByte() == 1;
        this.rcPaint = new LRECT();
        this.rcPaint.setLeft(this.getNextInt());
        this.rcPaint.setTop(this.getNextInt());
        this.rcPaint.setRight(this.getNextInt());
        this.rcPaint.setBottom(this.getNextInt());
        this.fRestore = this.getNextByte() == 1;
        boolean bl = this.fIncUpdate = this.getNextByte() == 1;
        if (this.rgbReserved != null) {
            for (int i = 0; i < this.rgbReserved.length; ++i) {
                this.rgbReserved[i] = this.getNextByte();
            }
        }
        this.offset = 0;
        return this;
    }

    @Override
    public Pointer createPointer() throws NativeException {
        if (this.pointer == null) {
            this.pointer = new Pointer(MemoryBlockFactory.createMemoryBlock(PAINTSTRUCT.sizeOf()));
        }
        return this.pointer;
    }

    @Override
    public PAINTSTRUCT getValue() {
        try {
            this.pointer.setIntAt(0, this.hdc != null ? this.hdc.getValue() : 0);
            this.pointer.setByteAt(4, this.fErase ? (byte)1 : 0);
            this.pointer.setIntAt(5, this.rcPaint.getLeft());
            this.pointer.setIntAt(9, this.rcPaint.getTop());
            this.pointer.setIntAt(13, this.rcPaint.getRight());
            this.pointer.setIntAt(17, this.rcPaint.getBottom());
            this.pointer.setByteAt(21, this.fRestore ? (byte)1 : 0);
            this.pointer.setByteAt(22, this.fIncUpdate ? (byte)1 : 0);
            if (this.rgbReserved != null) {
                for (int i = 0; i < this.rgbReserved.length; ++i) {
                    this.pointer.setByteAt(23 + i, this.rgbReserved[i]);
                }
            }
        }
        catch (NativeException ex) {
            ex.printStackTrace();
        }
        return this;
    }

    @Override
    public int getSizeOf() {
        return PAINTSTRUCT.sizeOf();
    }

    public static int sizeOf() {
        return 55;
    }
}

