/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.com.typebrowser.gui.panels;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import org.xvolks.jnative.com.typebrowser.business.CLSID;
import org.xvolks.jnative.com.typebrowser.business.CLSIDs;
import org.xvolks.jnative.com.typebrowser.gui.MainPanel;

public class ActiveXListPanel
extends JPanel {
    private static final long serialVersionUID = -2952977019519847929L;
    protected static final String GUID_COL_NAME = "GUID";
    protected static final String CONTROL_COL_NAME = "Control";
    private JTable activeXTable;

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add(new ActiveXListPanel());
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public ActiveXListPanel() {
        this.initGUI();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
            }
        });
    }

    private void initGUI() {
        try {
            Vector<String> headers = new Vector<String>();
            headers.add("ProgID");
            headers.add("Description");
            headers.add(CONTROL_COL_NAME);
            headers.add(GUID_COL_NAME);
            headers.add("InProcServer32");
            final CLSIDs clsids = new CLSIDs();
            Vector datas = new Vector();
            for (CLSID clsid : clsids.getCLSIDs()) {
                Vector<Object> data = new Vector<Object>();
                data.add(clsid.getProgID());
                data.add(clsid.getDescription());
                data.add(clsid.isControl());
                data.add(clsid.getGuid());
                data.add(clsid.getInprocServer32());
                datas.add(data);
            }
            GridBagLayout thisLayout = new GridBagLayout();
            thisLayout.rowWeights = new double[]{1.0, 0.1};
            thisLayout.rowHeights = new int[]{10, 1};
            thisLayout.columnWeights = new double[]{0.1};
            thisLayout.columnWidths = new int[]{7};
            this.setLayout(thisLayout);
            DefaultTableModel activeXTableModel = new DefaultTableModel(datas, headers){
                private static final long serialVersionUID = 6191716404387616674L;

                @Override
                public Class<?> getColumnClass(int c) {
                    try {
                        return this.getValueAt(0, c).getClass();
                    }
                    catch (NullPointerException e) {
                        return String.class;
                    }
                }

                @Override
                public boolean isCellEditable(int arg0, int arg1) {
                    return false;
                }
            };
            this.activeXTable = new JTable();
            JScrollPane scrollPane = new JScrollPane(this.activeXTable);
            this.activeXTable.setAutoCreateRowSorter(true);
            this.activeXTable.setAutoCreateColumnsFromModel(true);
            this.activeXTable.setModel(activeXTableModel);
            final TableRowSorter<2> sorter = new TableRowSorter<2>(activeXTableModel);
            final RowFilter<DefaultTableModel, Object> rf = new RowFilter<DefaultTableModel, Object>(){

                @Override
                public boolean include(RowFilter.Entry<? extends DefaultTableModel, ? extends Object> entry) {
                    try {
                        return (Boolean)entry.getValue(ActiveXListPanel.this.activeXTable.convertColumnIndexToModel(2));
                    }
                    catch (ClassCastException e) {
                        e.printStackTrace();
                        return false;
                    }
                }
            };
            sorter.setRowFilter(rf);
            this.activeXTable.setRowSorter(sorter);
            this.activeXTable.getSelectionModel().setSelectionMode(0);
            this.activeXTable.setDefaultRenderer(String.class, new CourrierRenderer());
            this.activeXTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    DefaultListSelectionModel dlsm;
                    if (e.getSource() instanceof DefaultListSelectionModel && (dlsm = (DefaultListSelectionModel)e.getSource()).getMinSelectionIndex() >= 0) {
                        int row = ActiveXListPanel.this.activeXTable.convertRowIndexToModel(dlsm.getMinSelectionIndex());
                        MainPanel.getInstance().getProjectPropertiesPanel().setClsid(clsids.getCLSIDs().get(row));
                    }
                }
            });
            TableColumn column = null;
            for (int i = 0; i < 5; ++i) {
                column = this.activeXTable.getColumnModel().getColumn(i);
                if (i == 2) {
                    column.setPreferredWidth(50);
                    continue;
                }
                column.setPreferredWidth(250);
            }
            this.add((Component)new JCheckBox("Filter controls"){
                private static final long serialVersionUID = -1833339236458660684L;
                {
                    super(x0);
                    this.setSelected(true);
                    this.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent arg0) {
                            sorter.setRowFilter(this.isSelected() ? rf : null);
                        }
                    });
                }
            }, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class CourrierRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 7282930193691161734L;
        Font f = new Font("Courier", 0, 12);

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value != null && value.toString().startsWith("{") && value.toString().endsWith("}")) {
                c.setFont(this.f);
            }
            return c;
        }
    }
}

