/*
 * Decompiled with CFR 0.152.
 */
package com.syc.function;

import org.xvolks.jnative.JNative;
import org.xvolks.jnative.Type;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;

public class Function {
    private static String functionLib = "libfunction.so";

    private static Pointer getPointer(byte[] s) {
        try {
            Pointer pointer = new Pointer(MemoryBlockFactory.createMemoryBlock((int)s.length));
            int i = 0;
            while (i < s.length) {
                pointer.setByteAt(i, s[i]);
                ++i;
            }
            return pointer;
        }
        catch (Exception e) {
            System.out.print("Failed to get Pointer Data!");
            return null;
        }
    }

    private static void getPointerData(Pointer p, byte[] s) {
        try {
            int i = 0;
            while (i < p.getSize()) {
                s[i] = p.getAsByte(i);
                ++i;
            }
        }
        catch (Exception e) {
            System.out.print("Failed to get Pointer Data!");
        }
    }

    private static int loadCommand(String functionName, int ... parameter) {
        JNative n = null;
        try {
            n = new JNative(functionLib, functionName);
            n.setRetVal(Type.INT);
            int i = 0;
            int[] nArray = parameter;
            int n2 = parameter.length;
            int n3 = 0;
            while (n3 < n2) {
                int p = nArray[n3];
                n.setParameter(i++, p);
                ++n3;
            }
            n.invoke();
            return Integer.parseInt(n.getRetVal());
        }
        catch (Exception e) {
            System.out.print("Failed to load libfunction.so");
            return 1;
        }
    }

    public static int API_SetSerNum(byte[] newValue, byte[] buffer) {
        Pointer newValuePtr = Function.getPointer(newValue);
        Pointer bufferPtr = Function.getPointer(buffer);
        int result = Function.loadCommand("API_SetSerNum", newValuePtr.getPointer(), bufferPtr.getPointer());
        Function.getPointerData(bufferPtr, buffer);
        return result;
    }

    public static int API_GetSerNum(byte[] buffer) {
        Pointer bufferPtr = Function.getPointer(buffer);
        int result = Function.loadCommand("API_GetSerNum", bufferPtr.getPointer());
        Function.getPointerData(bufferPtr, buffer);
        return result;
    }

    public static int WriteUserInfo(int num_blk, int num_length, byte[] user_info) {
        Pointer user_infoPtr = Function.getPointer(user_info);
        int result = Function.loadCommand("WriteUserInfo", num_blk, num_length, user_infoPtr.getPointer());
        Function.getPointerData(user_infoPtr, user_info);
        return result;
    }

    public static int ReadUserInfo(int num_blk, int num_length, byte[] user_info) {
        Pointer user_infoPtr = Function.getPointer(user_info);
        int result = Function.loadCommand("ReadUserInfo", num_blk, num_length, user_infoPtr.getPointer());
        Function.getPointerData(user_infoPtr, user_info);
        return result;
    }

    public static int GetVersionNum(byte[] VersionNum) {
        Pointer VersionNumPtr = Function.getPointer(VersionNum);
        int result = Function.loadCommand("GetVersionNum", VersionNumPtr.getPointer());
        Function.getPointerData(VersionNumPtr, VersionNum);
        return result;
    }

    public static int API_ControlLED(byte freq, byte duration, byte[] buffer) {
        Pointer bufferPtr = Function.getPointer(buffer);
        int result = Function.loadCommand("API_ControlLED", freq, duration, bufferPtr.getPointer());
        Function.getPointerData(bufferPtr, buffer);
        return result;
    }

    public static int API_ControlBuzzer(byte freq, byte duration, byte[] buffer) {
        Pointer bufferPtr = Function.getPointer(buffer);
        int result = Function.loadCommand("API_ControlBuzzer", freq, duration, bufferPtr.getPointer());
        Function.getPointerData(bufferPtr, buffer);
        return result;
    }

    public static int MF_Request(byte inf_mode, byte[] buffer) {
        Pointer bufferPtr = Function.getPointer(buffer);
        int result = Function.loadCommand("MF_Request", inf_mode, bufferPtr.getPointer());
        Function.getPointerData(bufferPtr, buffer);
        return result;
    }

    public static int MF_Anticoll(byte[] snr, byte[] status) {
        Pointer snrPtr = Function.getPointer(snr);
        Pointer statusPtr = Function.getPointer(status);
        int result = Function.loadCommand("MF_Anticoll", snrPtr.getPointer(), statusPtr.getPointer());
        Function.getPointerData(snrPtr, snr);
        Function.getPointerData(statusPtr, status);
        return result;
    }

    public static int MF_Select(byte[] snr) {
        Pointer snrPtr = Function.getPointer(snr);
        int result = Function.loadCommand("MF_Select", snrPtr.getPointer());
        Function.getPointerData(snrPtr, snr);
        return result;
    }

    public static int MF_Halt() {
        int result = Function.loadCommand("MF_Halt", new int[0]);
        return result;
    }

    public static int API_PCDRead(byte mode, byte blk_add, byte num_blk, byte[] snr, byte[] buffer) {
        Pointer snrPtr = Function.getPointer(snr);
        Pointer bufferPtr = Function.getPointer(buffer);
        int result = Function.loadCommand("API_PCDRead", mode, blk_add, num_blk, snrPtr.getPointer(), bufferPtr.getPointer());
        Function.getPointerData(snrPtr, snr);
        Function.getPointerData(bufferPtr, buffer);
        return result;
    }

    public static int API_PCDWrite(byte mode, byte blk_add, byte num_blk, byte[] snr, byte[] buffer) {
        Pointer snrPtr = Function.getPointer(snr);
        Pointer bufferPtr = Function.getPointer(buffer);
        int result = Function.loadCommand("API_PCDWrite", mode, blk_add, num_blk, snrPtr.getPointer(), bufferPtr.getPointer());
        Function.getPointerData(snrPtr, snr);
        return result;
    }

    public static int API_PCDInitVal(byte mode, byte SectNum, byte[] snr, byte[] value) {
        Pointer snrPtr = Function.getPointer(snr);
        Pointer valuePtr = Function.getPointer(value);
        int result = Function.loadCommand("API_PCDInitVal", mode, SectNum, snrPtr.getPointer(), valuePtr.getPointer());
        Function.getPointerData(snrPtr, snr);
        return result;
    }

    public static int API_PCDDec(byte mode, byte SectNum, byte[] snr, byte[] value) {
        Pointer snrPtr = Function.getPointer(snr);
        Pointer valuePtr = Function.getPointer(value);
        int result = Function.loadCommand("API_PCDDec", mode, SectNum, snrPtr.getPointer(), valuePtr.getPointer());
        Function.getPointerData(snrPtr, snr);
        return result;
    }

    public static int API_PCDInc(byte mode, byte SectNum, byte[] snr, byte[] value) {
        Pointer snrPtr = Function.getPointer(snr);
        Pointer valuePtr = Function.getPointer(value);
        int result = Function.loadCommand("API_PCDInc", mode, SectNum, snrPtr.getPointer(), valuePtr.getPointer());
        Function.getPointerData(snrPtr, snr);
        return result;
    }

    public static int GET_SNR(byte mode, byte API_halt, byte[] snr, byte[] value) {
        Pointer snrPtr = Function.getPointer(snr);
        Pointer valuePtr = Function.getPointer(value);
        int result = Function.loadCommand("GET_SNR", mode, API_halt, snrPtr.getPointer(), valuePtr.getPointer());
        Function.getPointerData(snrPtr, snr);
        Function.getPointerData(valuePtr, value);
        return result;
    }

    public static int MF_Restore(byte mode, int cardlength, byte[] carddata) {
        Pointer carddataPtr = Function.getPointer(carddata);
        int result = Function.loadCommand("MF_Restore", mode, cardlength, carddataPtr.getPointer());
        Function.getPointerData(carddataPtr, carddata);
        return result;
    }

    public static int RequestType_B(byte[] buffer) {
        Pointer bufferPtr = Function.getPointer(buffer);
        int result = Function.loadCommand("RequestType_B", bufferPtr.getPointer());
        Function.getPointerData(bufferPtr, buffer);
        return result;
    }

    public static int AntiType_B(byte[] buffer) {
        Pointer bufferPtr = Function.getPointer(buffer);
        int result = Function.loadCommand("AntiType_B", bufferPtr.getPointer());
        Function.getPointerData(bufferPtr, buffer);
        return result;
    }

    public static int SelectType_B(byte[] SerialNum) {
        Pointer SerialNumPtr = Function.getPointer(SerialNum);
        int result = Function.loadCommand("SelectType_B", SerialNumPtr.getPointer());
        Function.getPointerData(SerialNumPtr, SerialNum);
        return result;
    }

    public static int Request_AB(byte[] buffer) {
        Pointer bufferPtr = Function.getPointer(buffer);
        int result = Function.loadCommand("Request_AB", bufferPtr.getPointer());
        Function.getPointerData(bufferPtr, buffer);
        return result;
    }

    public static int API_ISO14443TypeBTransCOSCmd(byte[] cmd, int cmdSize, byte[] buffer) {
        Pointer cmdPtr = Function.getPointer(cmd);
        Pointer bufferPtr = Function.getPointer(buffer);
        int result = Function.loadCommand("API_ISO14443TypeBTransCOSCmd", cmdPtr.getPointer(), cmdSize, bufferPtr.getPointer());
        Function.getPointerData(bufferPtr, buffer);
        return result;
    }

    public static int API_ISO15693_Inventory(byte flag, byte afi, byte[] pData, byte[] nrOfCard, byte[] pBuffer) {
        Pointer pDataPtr = Function.getPointer(pData);
        Pointer nrOfCardPtr = Function.getPointer(nrOfCard);
        Pointer pBufferPtr = Function.getPointer(pBuffer);
        int result = Function.loadCommand("API_ISO15693_Inventory", flag, afi, pDataPtr.getPointer(), nrOfCardPtr.getPointer(), pBufferPtr.getPointer());
        Function.getPointerData(pDataPtr, pData);
        Function.getPointerData(nrOfCardPtr, nrOfCard);
        Function.getPointerData(pBufferPtr, pBuffer);
        return result;
    }

    public static int API_ISO15693Read(byte flags, byte blk_add, byte num_blk, byte[] uid, byte[] buffer) {
        Pointer uidPtr = Function.getPointer(uid);
        Pointer bufferPtr = Function.getPointer(buffer);
        int result = Function.loadCommand("API_ISO15693Read", flags, blk_add, num_blk, uidPtr.getPointer(), bufferPtr.getPointer());
        Function.getPointerData(uidPtr, uid);
        Function.getPointerData(bufferPtr, buffer);
        return result;
    }

    public static int API_ISO15693Write(byte flags, byte blk_add, byte num_blk, byte[] uid, byte[] data) {
        Pointer uidPtr = Function.getPointer(uid);
        Pointer dataPtr = Function.getPointer(data);
        int result = Function.loadCommand("API_ISO15693Write", flags, blk_add, num_blk, uidPtr.getPointer(), dataPtr.getPointer());
        Function.getPointerData(uidPtr, uid);
        Function.getPointerData(dataPtr, data);
        return result;
    }

    public static int API_ISO15693Lock(byte flags, byte num_blk, byte[] uid, byte[] buffer) {
        Pointer uidPtr = Function.getPointer(uid);
        Pointer bufferPtr = Function.getPointer(buffer);
        int result = Function.loadCommand("API_ISO15693Lock", flags, num_blk, uidPtr.getPointer(), bufferPtr.getPointer());
        Function.getPointerData(uidPtr, uid);
        Function.getPointerData(bufferPtr, buffer);
        return result;
    }

    public static int API_ISO15693StayQuiet(byte flags, byte[] uid, byte[] buffer) {
        Pointer uidPtr = Function.getPointer(uid);
        Pointer bufferPtr = Function.getPointer(buffer);
        int result = Function.loadCommand("API_ISO15693StayQuiet", flags, uidPtr.getPointer(), bufferPtr.getPointer());
        Function.getPointerData(uidPtr, uid);
        Function.getPointerData(bufferPtr, buffer);
        return result;
    }

    public static int API_ISO15693Select(byte flags, byte[] uid, byte[] buffer) {
        Pointer uidPtr = Function.getPointer(uid);
        Pointer bufferPtr = Function.getPointer(buffer);
        int result = Function.loadCommand("API_ISO15693Select", flags, uidPtr.getPointer(), bufferPtr.getPointer());
        Function.getPointerData(uidPtr, uid);
        Function.getPointerData(bufferPtr, buffer);
        return result;
    }

    public static int API_ResetToReady(byte flags, byte[] uid, byte[] buffer) {
        Pointer uidPtr = Function.getPointer(uid);
        Pointer bufferPtr = Function.getPointer(buffer);
        int result = Function.loadCommand("API_ResetToReady", flags, uidPtr.getPointer(), bufferPtr.getPointer());
        Function.getPointerData(uidPtr, uid);
        Function.getPointerData(bufferPtr, buffer);
        return result;
    }

    public static int API_WriteAFI(byte flags, byte afi, byte[] uid, byte[] buffer) {
        Pointer uidPtr = Function.getPointer(uid);
        Pointer bufferPtr = Function.getPointer(buffer);
        int result = Function.loadCommand("API_WriteAFI", flags, afi, uidPtr.getPointer(), bufferPtr.getPointer());
        Function.getPointerData(uidPtr, uid);
        Function.getPointerData(bufferPtr, buffer);
        return result;
    }

    public static int API_LockAFI(byte flags, byte[] uid, byte[] buffer) {
        Pointer uidPtr = Function.getPointer(uid);
        Pointer bufferPtr = Function.getPointer(buffer);
        int result = Function.loadCommand("API_LockAFI", flags, uidPtr.getPointer(), bufferPtr.getPointer());
        Function.getPointerData(uidPtr, uid);
        Function.getPointerData(bufferPtr, buffer);
        return result;
    }

    public static int API_WriteDSFID(byte flags, byte DSFID, byte[] uid, byte[] buffer) {
        Pointer uidPtr = Function.getPointer(uid);
        Pointer bufferPtr = Function.getPointer(buffer);
        int result = Function.loadCommand("API_WriteDSFID", flags, DSFID, uidPtr.getPointer(), bufferPtr.getPointer());
        Function.getPointerData(uidPtr, uid);
        Function.getPointerData(bufferPtr, buffer);
        return result;
    }

    public static int API_LockDSFID(byte flags, byte[] uid, byte[] buffer) {
        Pointer uidPtr = Function.getPointer(uid);
        Pointer bufferPtr = Function.getPointer(buffer);
        int result = Function.loadCommand("API_LockDSFID", flags, uidPtr.getPointer(), bufferPtr.getPointer());
        Function.getPointerData(uidPtr, uid);
        Function.getPointerData(bufferPtr, buffer);
        return result;
    }

    public static int API_ISO15693_GetSysInfo(byte flags, byte[] uid, byte[] buffer) {
        Pointer uidPtr = Function.getPointer(uid);
        Pointer bufferPtr = Function.getPointer(buffer);
        int result = Function.loadCommand("API_ISO15693_GetSysInfo", flags, uidPtr.getPointer(), bufferPtr.getPointer());
        Function.getPointerData(uidPtr, uid);
        Function.getPointerData(bufferPtr, buffer);
        return result;
    }

    public static int API_ISO15693_GetMulSecurity(byte flags, byte blkAddr, byte blkNum, byte[] uid, byte[] pBuffer) {
        Pointer uidPtr = Function.getPointer(uid);
        Pointer pBufferPtr = Function.getPointer(pBuffer);
        int result = Function.loadCommand("API_ISO15693_GetMulSecurity", flags, blkAddr, blkNum, uidPtr.getPointer(), pBufferPtr.getPointer());
        Function.getPointerData(uidPtr, uid);
        Function.getPointerData(pBufferPtr, pBuffer);
        return result;
    }

    public static int API_ISO15693TransCOSCmd(byte[] cmd, int cmdSize, byte[] buffer) {
        Pointer cmdPtr = Function.getPointer(cmd);
        Pointer bufferPtr = Function.getPointer(buffer);
        int result = Function.loadCommand("API_ISO15693TransCOSCmd", cmdPtr.getPointer(), cmdSize, bufferPtr.getPointer());
        Function.getPointerData(cmdPtr, cmd);
        Function.getPointerData(bufferPtr, buffer);
        return result;
    }

    public static int UL_HLRead(byte mode, byte blk_add, byte[] snr, byte[] buffer) {
        Pointer snrPtr = Function.getPointer(snr);
        Pointer bufferPtr = Function.getPointer(buffer);
        int result = Function.loadCommand("UL_HLRead", mode, blk_add, snrPtr.getPointer(), bufferPtr.getPointer());
        Function.getPointerData(snrPtr, snr);
        Function.getPointerData(bufferPtr, buffer);
        return result;
    }

    public static int UL_HLWrite(byte mode, byte blk_add, byte[] snr, byte[] buffer) {
        Pointer snrPtr = Function.getPointer(snr);
        Pointer bufferPtr = Function.getPointer(buffer);
        int result = Function.loadCommand("UL_HLWrite", mode, blk_add, snrPtr.getPointer(), bufferPtr.getPointer());
        Function.getPointerData(snrPtr, snr);
        Function.getPointerData(bufferPtr, buffer);
        return result;
    }

    public static int UL_Request(byte mode, byte[] snr) {
        Pointer snrPtr = Function.getPointer(snr);
        int result = Function.loadCommand("UL_Request", mode, snrPtr.getPointer());
        Function.getPointerData(snrPtr, snr);
        return result;
    }
}

